<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Json;

use DawidRza\Component\Http\Exception\JsonException;

/**
 * @template T of object
 * @internal
 */
abstract class Hydrator
{
    final public function __construct(
        protected HydratorRegistry $registry,
    ) {
    }

    /**
     * @return T
     * @throws JsonException
     */
    final public function hydrate(array $source): object
    {
        $errors = [];
        $object = $this->doHydrate($source, $errors);

        if (count($errors) > 0) {
            throw JsonException::format($errors);
        }

        return $object;
    }

    /**
     * @return T
     */
    abstract protected function doHydrate(array $source, array &$errors): object;
}
