<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Exception;

use DawidRza\Component\Http\Metadata\ClassMetadata;
use DawidRza\Component\Http\Metadata\PropertyMetadata;
use Throwable;

enum BindError
{
    case INVALID_ENUM;
    case INVALID_TYPE;
    case UNKNOWN;
    case UNSUPPORTED_CONTENT_TYPE;
    case VALUE_REQUIRED;

    /**
     * @throws BindException
     */
    public function raise(ClassMetadata $class, PropertyMetadata $property, ?Throwable $reason = null): void
    {
        throw new BindException($this, $class, $property, $reason);
    }
}
