<?php

declare(strict_types=1);

namespace DawidRza\Component\Http;

enum ContentType: string
{
    private const array HEADER_MAP = [
        'application/json' => self::JSON,
        'application/x-www-form-urlencoded' => self::FORM,
        'multipart/form-data' => self::FORM,
        'text/html' => self::HTML,
        'text/plain' => self::TEXT,
    ];

    case FORM = 'form';
    case HTML = 'html';
    case JSON = 'json';
    case TEXT = 'text';

    public static function tryFromString(string $contentType): ?self
    {
        return self::tryFrom($contentType) ?? self::HEADER_MAP[$contentType] ?? null;
    }

    /**
     * @return list<string>
     */
    public function getMimeTypes(): array
    {
        $mimeTypes = [];

        foreach (self::HEADER_MAP as $mimeType => $contentType) {
            $contentType === $this && $mimeTypes[] = $mimeType;
        }

        return $mimeTypes;
    }
}
