<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Type\Received;

use DateTimeImmutable;
use DawidRza\Component\EmailClient\Type\Address;
use DawidRza\Component\EmailClient\Type\Content;
use DawidRza\Component\EmailClient\Type\ReadonlyTrait;

/**
 * @property-read int $UID
 * @property-read list<ReceivedAttachment> $attachments
 * @property-read list<Content> $body
 * @property-read list<string> $flags
 * @property-read list<ReceivedHeader> $headers
 * @property-read Address $sender
 * @property-read DateTimeImmutable $receivedAt
 * @property-read list<Address> $recipients
 * @property-read ?string $subject
 */
final class ReceivedMessage
{
    use ReadonlyTrait;

    /** @var int */
    private $UID;

    /** @var list<ReceivedAttachment> */
    private $attachments;

    /** @var list<Content> */
    private $body;

    /** @var list<string> */
    private $flags;

    /** @var list<ReceivedHeader> */
    private $headers;

    /** @var Address */
    private $sender;

    /** @var DateTimeImmutable */
    private $receivedAt;

    /** @var list<Address> */
    private $recipients;

    /** @var ?string */
    private $subject;

    /**
     * @param list<ReceivedAttachment> $attachments
     * @param list<Content> $body
     * @param list<string> $flags
     * @param list<ReceivedHeader> $headers
     * @param list<Address> $recipients
     */
    private function __construct(
        int $UID,
        array $attachments,
        array $body,
        array $flags,
        array $headers,
        Address $sender,
        DateTimeImmutable $receivedAt,
        array $recipients,
        ?string $subject
    ) {
        $this->UID = $UID;
        $this->attachments = $attachments;
        $this->body = $body;
        $this->flags = $flags;
        $this->headers = $headers;
        $this->sender = $sender;
        $this->receivedAt = $receivedAt;
        $this->recipients = $recipients;
        $this->subject = $subject;
    }

    /**
     * @param list<ReceivedAttachment> $attachments
     * @param list<Content> $body
     * @param list<string> $flags
     * @param list<ReceivedHeader> $headers
     * @param list<Address> $recipients
     */
    public static function create(
        int $UID,
        array $attachments,
        array $body,
        array $flags,
        array $headers,
        Address $sender,
        DateTimeImmutable $receivedAt,
        array $recipients,
        ?string $subject
    ): self
    {
        return new self(
            $UID,
            $attachments,
            $body,
            $flags,
            $headers,
            $sender,
            $receivedAt,
            $recipients,
            $subject
        );
    }
}
