<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Type\Received;

use DawidRza\Component\EmailClient\Type\ReadonlyTrait;

/**
 * @property-read string $name
 * @property-read null|string|list<string> $value
 */
final class ReceivedHeader
{
    use ReadonlyTrait;

    /** @var string */
    private $name;

    /** @var null|string|list<string> */
    private $value;

    /**
     * @param null|string|list<string> $value
     */
    private function __construct(
        string $name,
        $value
    ) {
        $this->name = $name;
        $this->value = $value;
    }

    /**
     * @param null|string|list<string> $value
     */
    public static function create(string $name, $value): self
    {
        return new self($name, $value);
    }
}
