<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Type\Received;

use DawidRza\Component\EmailClient\Type\ReadonlyTrait;

/**
 * @property-read string $content
 * @property-read string $filename
 */
final class ReceivedAttachment
{
    use ReadonlyTrait;

    /** @var string */
    private $content;

    /** @var string */
    private $filename;

    private function __construct(
        string $content,
        string $filename
    ) {
        $this->content = $content;
        $this->filename = $filename;
    }

    public static function create(string $content, string $filename): self
    {
        return new ReceivedAttachment(
            $content,
            $filename,
        );
    }
}
