<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Type;

/**
 * @property-read string $name
 * @property-read list<list<string>> $flags
 * @property-read int $nextUID
 * @property-read int $messageCount
 */
final class Folder
{
    use ReadonlyTrait;

    /** @var string */
    private $name;

    /** @var list<list<string>> */
    private $flags;

    /** @var int */
    private $nextUID;

    /** @var int */
    private $messageCount;

    /**
     * @param list<list<string>> $flags
     */
    private function __construct(
        string $name,
        array $flags,
        int $nextUID,
        int $messageCount
    ) {
        $this->name = $name;
        $this->flags = $flags;
        $this->nextUID = $nextUID;
        $this->messageCount = $messageCount;
    }

    /**
     * @param list<list<string>> $flags
     */
    public static function create(string $name, array $flags, int $nextUID, int $messageCount): self
    {
        return new self(
            $name,
            $flags,
            $nextUID,
            $messageCount,
        );
    }
}
