<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Type\Discovery;

use DawidRza\Component\EmailClient\Type\ReadonlyTrait;

/**
 * @property-read string $authenticationType
 * @property-read string $host
 * @property-read int $port
 * @property-read string $protocolType
 * @property-read string $socketType
 * @property-read string $usernameType
 */
final class ServerInformation
{
    use ReadonlyTrait;

    /** @var string */
    private $authenticationType;

    /** @var string */
    private $host;

    /** @var int */
    private $port;

    /** @var string */
    private $protocolType;

    /** @var string */
    private $socketType;

    /** @var string */
    private $usernameType;

    private function __construct(
        string $authenticationType,
        string $host,
        int $port,
        string $protocolType,
        string $socketType,
        string $usernameType
    ) {
        $this->authenticationType = $authenticationType;
        $this->host = $host;
        $this->port = $port;
        $this->protocolType = $protocolType;
        $this->socketType = $socketType;
        $this->usernameType = $usernameType;
    }

    public static function create(
        string $authenticationType,
        string $host,
        int $port,
        string $protocolType,
        string $socketType,
        string $usernameType
    ): self
    {
        return new self($authenticationType, $host, $port, $protocolType, $socketType, $usernameType);
    }
}
