<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Type\Discovery;

use DawidRza\Component\EmailClient\Type\ReadonlyTrait;

/**
 * @property-read string $displayName
 * @property-read string $domain
 * @property-read list<ServerInformation> $incomingServers
 * @property-read list<ServerInformation> $outgoingServers
 */
final class DiscoveryInformation
{
    use ReadonlyTrait;

    /** @var string */
    private $displayName;

    /** @var string */
    private $domain;

    /** @var list<ServerInformation> */
    private $incomingServers;

    /** @var list<ServerInformation> */
    private $outgoingServers;

    /**
     * @param list<ServerInformation> $incomingServers
     * @param list<ServerInformation> $outgoingServers
     */
    private function __construct(
        string $displayName,
        string $domain,
        array $incomingServers,
        array $outgoingServers
    ) {
        $this->displayName = $displayName;
        $this->domain = $domain;
        $this->incomingServers = $incomingServers;
        $this->outgoingServers = $outgoingServers;
    }

    /**
     * @param list<ServerInformation> $incomingServers
     * @param list<ServerInformation> $outgoingServers
     */
    public static function create(
        string $displayName,
        string $domain,
        array $incomingServers,
        array $outgoingServers
    ): self
    {
        return new self(
            $displayName,
            $domain,
            $incomingServers,
            $outgoingServers
        );
    }
}
