<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Type;

use DawidRza\Component\EmailClient\Exception\UnsupportedContentTypeException;

/**
 * @property-read string $type
 * @property-read string $content
 */
final class Content
{
    use ReadonlyTrait;

    /** @var string */
    private $type;

    /** @var string */
    private $content;

    private function __construct(
        string $content,
        string $type
    ) {
        $this->content = $content;
        $this->type = $type;
    }

    public static function create(string $content, string $type): self
    {
        if (!in_array($type, ContentType::cases(), true)) {
            throw new UnsupportedContentTypeException(sprintf(
                "Expected the content type to be one of <%s>, but got %s",
                implode(',', ContentType::cases()),
                $type,
            ));
        }

        return new self($content, $type);
    }
}
