<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Type;

/**
 * @property-read string $filename
 * @property-read string $url
 * @property-read bool $inline
 */
final class Attachment
{
    use ReadonlyTrait;

    /** @var string */
    private $filename;

    /** @var string */
    private $url;

    /** @var bool */
    private $inline;

    private function __construct(
        string $filename,
        string $url,
        bool $inline
    ) {
        $this->filename = $filename;
        $this->url = $url;
        $this->inline = $inline;
    }

    public static function create(string $filename, string $url, bool $inline): self
    {
        return new self(
            $filename,
            $url,
            $inline,
        );
    }
}
