<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Type;

/**
 * @property-read string $email
 * @property-read ?string $title
 */
final class Address
{
    use ReadonlyTrait;

    /** @var string */
    private $email;

    /** @var ?string */
    private $title;

    private function __construct(
        string $email,
        ?string $title
    ) {
        $this->email = $email;
        $this->title = $title;
    }

    public static function create(string $email, ?string $title = null): self
    {
        return new self($email, $title);
    }
}
