<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Type\Account;

use DawidRza\Component\EmailClient\Type\ReadonlyTrait;

/**
 * @property-read string $protocol
 * @property-read string $host
 * @property-read int $port
 * @property-read string $username
 * @property-read string $password
 */
final class IncomingServer
{
    use ReadonlyTrait;

    /** @var string */
    private $protocol;

    /** @var string */
    private $host;

    /** @var int */
    private $port;

    /** @var string */
    private $username;

    /** @var string */
    private $password;

    private function __construct(
        string $protocol,
        string $host,
        int $port,
        string $username,
        string $password
    ) {
        $this->protocol = $protocol;
        $this->host = $host;
        $this->port = $port;
        $this->username = $username;
        $this->password = $password;
    }

    public static function create(string $protocol, string $host, int $port, string $username, string $password): self
    {
        return new self(
            $protocol,
            $host,
            $port,
            $username,
            $password,
        );
    }
}
