<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Symfony;

use DawidRza\Component\EmailClient\EmailClient;
use DawidRza\Component\EmailClient\EmailClientFactory;

final class GuzzleClientFactory implements EmailClientFactory
{
    public function create(string $baseUri, string $clientId, string $clientSecret): EmailClient
    {
        return new GuzzleEmailClient(
            new GuzzleHttpClient(
                $baseUri,
                $clientId,
                $clientSecret
            ),
        );
    }
}
