<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Symfony\DependencyInjection;

use DawidRza\Component\EmailClient\EmailClientFactory;
use DawidRza\Component\EmailClient\Symfony\GuzzleClientFactory;
use GuzzleHttp\Client;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;

final class EmailClientExtension extends Extension
{
    /**
     * @param array<mixed> $configs
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $serviceDefinition = $container
            ->register(EmailClientFactory::class);

        if (class_exists(Client::class)) {
            $serviceDefinition
                ->setClass(GuzzleClientFactory::class);

            $container
                ->register(GuzzleClientFactory::class);
        }
    }
}
