<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient\Exception;

use Exception;

final class TransportException extends Exception
{
    public const RESPONSE_CODE_UNEXPECTED = 1;
    public const RESPONSE_FORMAT_UNEXPECTED = 2;

    private function __construct(
        string $message,
        int $statusCode
    ) {
        parent::__construct($message, $statusCode);
    }

    public static function unexpectedResponseCode(string $message): self
    {
        return new self(
            $message,
            self::RESPONSE_CODE_UNEXPECTED,
        );
    }

    public static function unexpectedResponseFormat(string $message): self
    {
        return new self(
            $message,
            self::RESPONSE_FORMAT_UNEXPECTED,
        );
    }

    public function is(int $code): bool
    {
        return $this->getCode() === $code;
    }
}
