<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient;

use DawidRza\Component\EmailClient\Exception\ConnectionUnestablishedException;
use DawidRza\Component\EmailClient\Exception\TransportException;
use DawidRza\Component\EmailClient\Type\Account\IncomingServer;
use DawidRza\Component\EmailClient\Type\Account\OutgoingServer;
use DawidRza\Component\EmailClient\Type\Discovery\DiscoveryInformation;

interface EmailClient
{
    /**
     * @throws ConnectionUnestablishedException When the connection to the mailer could not be established.
     * @throws TransportException When the transport of the request was unsuccessful.
     */
    public function discoverConfiguration(string $domain): ?DiscoveryInformation;

    /**
     * @throws ConnectionUnestablishedException When the connection to the mailer could not be established.
     * @throws TransportException When the transport of the request was unsuccessful.
     */
    public function registerAccount(IncomingServer $incomingServer, OutgoingServer $outgoingServer): string;

    public function getAccount(string $accountId): EmailAccount;
}
