<?php

declare(strict_types=1);

namespace DawidRza\Component\EmailClient;

use DateTimeImmutable;
use DawidRza\Component\EmailClient\Exception\ConnectionUnestablishedException;
use DawidRza\Component\EmailClient\Exception\InvalidMessageException;
use DawidRza\Component\EmailClient\Exception\TransportException;
use DawidRza\Component\EmailClient\Type\Folder;
use DawidRza\Component\EmailClient\Type\Message;
use DawidRza\Component\EmailClient\Type\Received\ReceivedMessage;

interface EmailAccount
{
    /**
     * @throws ConnectionUnestablishedException When the connection to the mailer could not be established.
     * @throws TransportException When the transport of the request was unsuccessful.
     */
    public function getFolder(string $folderName): Folder;

    /**
     * @return iterable<int, Folder>
     *
     * @throws ConnectionUnestablishedException When the connection to the mailer could not be established.
     * @throws TransportException When the transport of the request was unsuccessful.
     */
    public function getFolders(): iterable;

    /**
     * @return iterable<int, ReceivedMessage>
     *
     * @throws ConnectionUnestablishedException When the connection to the mailer could not be established.
     * @throws TransportException When the transport of the request was unsuccessful.
     */
    public function getMessages(
        string $folderName,
        ?int $startingUID = null,
        ?int $limit = null
    ): iterable;

    /**
     * @throws InvalidMessageException When the message provided is invalid.
     * @throws ConnectionUnestablishedException When the connection to the mailer could not be established.
     * @throws TransportException When the transport of the request was unsuccessful.
     */
    public function sendEmail(Message $message, ?DateTimeImmutable $dispatchedAt): void;
}
